import pylab as plt
import scipy as sp
import scipy.linalg as lin
from ndtools.clines import *

# Example code for BENG 260 Homework 3, Fall 2019
# Questions to mwagner@ucsd.edu or jmford@ucsd.edu
#
# We will do an analysis of a two-dimensional nonlinear ODE system.
# The equations that describe this system are:
#
#    Dx = -b*x -sin(y-a)
#    Dy = x
#
# ** For the problems, read through and run the code below see examples of the
# getNullclines, getCrossings and getJacobian which are included in the
# ndtools.clines module.
#
#
# 1. Use meshgrid to create an 2D matrix of (x,y) values:
#   Range:
#   -2  <=  x  <=  2
#   -pi <=  y  <=  pi
#   Parameter values:
#   b = 0;  a = 0;
#   b = 0;  a = pi/2;
#   b = 0;  a = pi;
#   b = 1;  a = pi/2;
#   b = 1;  a = pi;

# define pi
pi = sp.pi

# 2D-axis specification
N = 25
x = sp.linspace(-2,2,N)
y = sp.linspace(-pi,pi,N)
X, Y = sp.meshgrid(x,y)

# Constants
a = [0, pi/2, pi, pi/2, pi];
b = [0, 0, 0, 1, 1];


for i in range(len(a)):
	# Constants
	A = a[i]
	B = b[i]

	# 2D system of equations
	DX = -B*X - sp.sin(Y-A)
	DY = X

	# 2. Use getNullcline to get a pair of nullclines for each set of parameters.
	ncX_x, ncX_y = getNullcline(DX,x,y)	# get X nullcline
	ncY_x, ncY_y = getNullcline(DY,x,y)	# get Y nullcline

	# 3. Use getCrossings to identify the fixed-points of the system
	fp_x, fp_y = getCrossings(ncX_x,ncX_y, ncY_x,ncY_y)

	# Make sure we have only the first fixed-point
	fp_x_0, fp_y_0 = fp_x[0], fp_y[0]

	# 4. Try linearizing the system around the fixed-points using getJacobian.
	#   Compute the eigenvalues of this matrix, using the eig
	#   function or the SVD function. Make sure the eigenvalues confirm the
	#   dynamics of the gradient map.
	J = getJacobian(X,Y,DX,DY,fp_x_0,fp_y_0)
	[eig_val, eig_vec] = lin.eig(J)
	print('Eigenvalues =', eig_val)


	# Plotting the null-clines and fixed-points
	plt.figure(i);
	plt.quiver(X,Y,DX,DY, scale=20, label='Gradient')
	plt.plot(ncX_x, ncX_y, 'k', label='F(x,y) = 0')
	plt.plot(ncY_x, ncY_y, 'k', label='G(x,y) = 0')
	plt.plot(fp_x,  fp_y,  'ro', linewidth=2)
	plt.xlabel('x')
	plt.ylabel('y')
	plt.legend(loc='lower right')
	plt.title('Nullclines and Fixed Points');
	plt.show()
